<?php
include 'config.php';

// Hàm trim và rename ảnh
function uploadImage($file, $alias) {
    $target_dir = "../images/" . strtolower(trim($alias)) . "/";
    
    // Kiểm tra và tạo thư mục nếu chưa tồn tại
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true);
    }

    $timestamp = time();
    $file_name = strtolower(trim($alias)) . "_" . $timestamp . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
    $target_file = $target_dir . $file_name;

    if (move_uploaded_file($file["tmp_name"], $target_file)) {
        return $target_file;
    } else {
        return null;
    }
}
function generateAlias($name)
{
    // Chuyển thành chữ thường
    $alias = strtolower($name);
    // Thay thế các ký tự không phải chữ cái và số bằng dấu gạch ngang
    $alias = preg_replace('/[^a-z0-9]+/i', '-', trim($alias));
    // Loại bỏ các dấu gạch ngang ở đầu và cuối
    $alias = trim($alias, '-');
    return $alias;
}

// Thêm game
if (isset($_POST['add'])) 
{
    $name = $conn->real_escape_string($_POST['name']);
    //$alias = $conn->real_escape_string($_POST['alias']);
	$alias = generateAlias($name);
    $refLink = $conn->real_escape_string($_POST['reflink']);
    $descriptions= $conn->real_escape_string($_POST['descriptions']);
    $logo = uploadImage($_FILES['logo'], $alias);

    if ($logo)
	{
        $sql = "INSERT INTO Games (GameName, GameAlias, GameLogo, RefLink, Descriptions) VALUES ('$name', '$alias', '$logo', '$refLink','$descriptions')";
        //$conn->query($sql);
		if ($conn->query($sql) === TRUE) {
			echo "Record updated successfully";
		} else {
			echo "Error updating record: " . $conn->error;
		}
    }
}

// Sửa game
if (isset($_POST['edit'])) {
    $id = $conn->real_escape_string($_POST['id']);
    $name = $conn->real_escape_string($_POST['name']);
    $alias = $conn->real_escape_string($_POST['alias']);
    $refLink = $conn->real_escape_string($_POST['reflink']);
    $descriptions = $conn->real_escape_string($_POST['descriptions']);
    $logo = uploadImage($_FILES['logo'], $alias);

    if ($logo) {
        $sql = "UPDATE Games SET GameName='$name', GameAlias='$alias', GameLogo='$logo', RefLink='$refLink' , Descriptions = '$descriptions' WHERE GameID=$id";
    } else {
        $sql = "UPDATE Games SET GameName='$name', GameAlias='$alias', RefLink='$refLink', Descriptions = '$descriptions' WHERE GameID=$id";
    }

    $conn->query($sql);
}

// Xóa game
if (isset($_GET['delete'])) {
    $id = $conn->real_escape_string($_GET['delete']);
    $sql = "DELETE FROM Games WHERE GameID=$id";
    $conn->query($sql);
}

// Hiển thị danh sách game
$games = $conn->query("SELECT * FROM `Games` ORDER BY click_count DESC, GameAlias ASC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Quản lý Game</title>
	<link rel="stylesheet" type="text/css" href="admin_styles.css" />
	<script>
		function confirmDelete() {return confirm("Are you sure you want to delete this item?");}
	</script>
</head>
<body>
    <div class="container">
        <div class="form-container">
            <h1>Thêm/Sửa Game</h1>

			<?php
				/// Kiểm tra nếu đang ở chế độ chỉnh sửa
				if (isset($_GET['edit'])) 
				{
					$id1 = $_GET['edit'];
					// Truy vấn lấy thông tin GameData
					$sql1 = "SELECT * from Games where GameID = $id1";
					$result1 = $conn->query($sql1);
					if ($result1->num_rows > 0) 
					{
						$row1 = $result1->fetch_assoc();
						$gameid1 = $row1['GameID'];
						$gameName1 = $row1['GameName'];
						$gameAlias1 = $row1['GameAlias'];
						$image1 = $row1['GameLogo'];
						$refLink1 = $row1['RefLink'];
						$gameDescriptions1 = $row1['Descriptions'];
					}
					else 
					{
						echo "Không tìm thấy GameData.";
					}
				} 
			?>

            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo isset($_GET['edit']) ? $_GET['edit'] : ''; ?>">
                <label>Tên Game:</label>
                <input type="text" name="name" value="<?php echo $gameName1; ?>" required>
                <label>Alias:</label>
                <input type="text" name="alias" value="<?php echo $gameAlias1; ?>" readonly>
                <label>RefLink:</label>
                <input type="text" name="reflink" value="<?php echo $refLink1; ?>">
                <label>Logo:</label>
                <input type="file" name="logo">
				<?php if (!empty($image1)): ?>
				<p>Hình ảnh hiện tại: <img src="../<?php echo $image1; ?>" alt="Image" style="width: 100px;"></p>
				<?php endif; ?>
                <label>Description:</label>
                <textarea name="descriptions" rows="4"><?php echo $gameDescriptions1; ?></textarea>

                <button type="submit" name="<?php echo isset($_GET['edit']) ? 'edit' : 'add'; ?>">
                    <?php echo isset($_GET['edit']) ? 'Sửa' : 'Thêm'; ?>
                </button>
            </form>
        </div>
        <div class="game-grid">
            <?php while ($game = $games->fetch_assoc()): ?>
            <div class="game-item">
                <img src="<?php echo $game['GameLogo']; ?>" alt="<?php echo $game['GameName']; ?>">
                <h3><?php echo $game['GameName']; ?> (<?php echo $game['click_count']; ?>)</h3>
                <!--p><?php echo $game['RefLink']; ?></p--><br/>
                <!--a href="index.php?delete=<?php echo $game['GameID']; ?>" onclick="return confirmDelete();">Xóa</a-->
                <!--a href="index.php?edit=<?php echo $game['GameID']; ?>">Sửa</a--><br>
				<a href="gamedata.php?gameid=<?php echo $game['GameID']; ?>&add=<?php echo $game['GameID']; ?>">Thêm GameData</a> <!-- Nút thêm GameData -->
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</body>
</html>

<?php $conn->close(); ?>
