<?php
include 'config.php';
// Bật báo lỗi để xem lỗi chi tiết (chỉ sử dụng trong quá trình phát triển)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Upload function
function uploadImage($file, $gameAlias) {
    if ($file['name']) {  // check if user choose image to upload
        $target_dir = "../images/" . strtolower(trim($gameAlias)) . "/";

        // Check folder exist and create
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }

        $timestamp = time();
        $file_name = strtolower(trim($gameAlias)) . "_" . $timestamp . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
        $target_file = $target_dir . $file_name;

        if (move_uploaded_file($file["tmp_name"], $target_file)) {return $file_name;}
		else {return null;}
    } 
	else 
	{
		return null;  // Return null if no image
	}
}

// Add GameData
if (isset($_POST['add'])) {
    $gameID = $conn->real_escape_string($_POST['gameid']);
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $youtubeLink = !empty($_POST['youtubelink']) ? $conn->real_escape_string($_POST['youtubelink']) : null;

    // Get gamealias from Game table
    $result = $conn->query("SELECT GameAlias FROM Games WHERE GameID = '$gameID'");
    $game = $result->fetch_assoc();
    $gameAlias = $game['GameAlias'];

    $image = uploadImage($_FILES['image'], $gameAlias);

    $sql = "INSERT INTO GameData (GameID, Title, Description, Image, YoutubeLink) VALUES ('$gameID', '$title', '$description', ";

    if ($image) {$sql .= "'$image', ";}
	else {$sql .= "NULL, ";}

    if ($youtubeLink) {$sql .= "'$youtubeLink')";}
	else {$sql .= "NULL)";}

    if ($conn->query($sql) === TRUE) {echo "New GameData created successfully";}
	else {echo "Error: " . $sql . "<br>" . $conn->error;}
}

// Edit GameData
if (isset($_POST['edit']))
{
    $id = $conn->real_escape_string($_POST['id']);
    $gameID = $conn->real_escape_string($_POST['gameid']);
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $youtubeLink = !empty($_POST['youtubelink']) ? $conn->real_escape_string($_POST['youtubelink']) : null;

    // Get gamealias from Game
    $result = $conn->query("SELECT GameAlias FROM Games WHERE GameID = '$gameID'");
    $game = $result->fetch_assoc();
    $gameAlias = $game['GameAlias'];

    $image = uploadImage($_FILES['image'], $gameAlias);

    $sql = "UPDATE GameData SET GameID='$gameID', Title='$title', Description='$description', ";

    if ($image) {$sql .= "Image='$image', ";}

    if ($youtubeLink) {$sql .= "YoutubeLink='$youtubeLink' ";}
	else {$sql .= "YoutubeLink=NULL ";}

    $sql .= "WHERE ID=$id";

    if ($conn->query($sql) === TRUE) {echo "GameData updated successfully";}
	else {echo "Error updating record: " . $conn->error;}
}

// Delete game

if (isset($_GET['delete'])) {
    $id = $conn->real_escape_string($_GET['delete']);
    $sql = "DELETE FROM GameData WHERE ID=$id";
    $conn->query($sql);
}

// Hiển thị danh sách GameData

// Get GameID từ URL
$gameID = isset($_GET['gameid']) ? $conn->real_escape_string($_GET['gameid']) : null;

// Xây dựng câu truy vấn SQL
$sql = "SELECT gd.*, g.* FROM GameData gd LEFT JOIN Games g ON gd.GameID = g.GameID";

// Nếu có tham số GameID, thêm điều kiện vào câu truy vấn
if ($gameID) {$sql .= " WHERE gd.GameID = '$gameID' order by gd.ID desc";}

// Thực thi truy vấn
$gamedata = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Quản lý GameData</title>
    <!-- CSS here -->
	<style>
        h1, h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        form {
            max-width: 600px;
            margin: 0 auto 20px;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        label {
            display: block;
            margin-bottom: 10px;
            font-weight: bold;
        }

        input[type="text"],
        textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="file"] {
            margin-bottom: 20px;
        }

        input[type="submit"] {
            padding: 10px 20px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #218838;
        }

        .airdrop-container {
            display: flex;
            flex-direction: column;
            gap: 10px;
            padding: 20px;
        }

        .airdrop-item {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 15px;
            align-items: left;
            justify-content: space-between;
        }

        .airdrop-item h3 {
            font-size: 18px;
            margin: 0;
        }

        .airdrop-item img {
            max-height: 150px;
            margin-left: 20px;
            border-radius: 4px;
        }

        .airdrop-item p {
            font-size: 14px;
            color: #666;
            margin: 0;
            padding-left: 20px;
        }

        .airdrop-item a {
            margin-left: 20px;
            color: #007bff;
            text-decoration: none;
        }

        .airdrop-item a:hover {
            text-decoration: underline;
        }
		</style>
	<link rel="stylesheet" type="text/css" href="admin_styles.css" />
	<link href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css" rel="stylesheet">
	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

	<!-- include summernote css/js -->
	<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
	<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
	<script>
        $(document).ready(function() {
            $('#description').summernote({
                height: 300
            });
        });
    </script>
</head>
<body>
    <div class="container">
<div class="form-container">
    <h1><a href="index.php">HOME</a></h1>
    <h1>Thêm/Sửa GameData</h1>
    <?php
		/// Kiểm tra nếu đang ở chế độ chỉnh sửa
		if (isset($_GET['edit'])) 
		{
			$id = $conn->real_escape_string($_GET['edit']);
			
			// Truy vấn lấy thông tin GameData
			$sql = "SELECT gd.*, g.GameAlias FROM GameData gd JOIN Games g WHERE gd.GameId = g.GameID and gd.ID = $id";
			$result = $conn->query($sql);

			if ($result->num_rows > 0) 
			{
				$row = $result->fetch_assoc();
				$gameid = $row['GameID'];
				$title = $row['Title'];
				$description = $row['Description'];
				$youtubelink = $row['YoutubeLink'];
				$image = $row['Image'];
				$gameAlias = $row['GameAlias'];
			} else {
				echo "Không tìm thấy GameData.";
			}
		} 
		else
		{
			$gameid = isset($_GET['gameid']) ? $_GET['gameid'] : '';
			$title = '';
			$description = '';
			$youtubelink = '';
			$image = '';
		}
    ?>

    <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?php echo isset($_GET['edit']) ? $_GET['edit'] : ''; ?>">
        <?php if (empty($gameid)): ?>
        <label>Chọn Game:</label>
        <select name="gameid" required>
            <option value="">--Chọn Game--</option>
            <?php
            $games = $conn->query("SELECT * FROM Games ORDER BY GameAlias");
            while ($game = $games->fetch_assoc()):
            ?>
            <option value="<?php echo $game['GameID']; ?>" <?php echo ($game['GameID'] == $gameid) ? 'selected' : ''; ?>><?php echo $game['GameName']; ?></option>
            <?php endwhile; ?>
        </select>
        <?php else: ?>
            <input type="hidden" name="gameid" value="<?php echo $gameid; ?>">
        <?php endif; ?>

        <label>Tiêu đề:</label>
        <input type="text" name="title" value="<?php echo $title; ?>" required>
        
        <label>Mô tả:</label>
        <textarea name="description" rows="4" id="description"><?php echo $description; ?></textarea>
        
        <label>Link Youtube:</label>
        <input type="text" name="youtubelink" value="<?php echo $youtubelink; ?>">
        
        <label>Hình ảnh:</label>
        <input type="file" name="image">
        <?php if (!empty($image)): ?>
        <p>Hình ảnh hiện tại: <img src="../images/<?php echo $gameAlias; ?>/<?php echo $image; ?>" alt="Image" style="width: 100px;"></p>
        <?php endif; ?>
        
        <button type="submit" name="<?php echo isset($_GET['edit']) ? 'edit' : 'add'; ?>">
            <?php echo isset($_GET['edit']) ? 'Sửa' : 'Thêm'; ?>
        </button>
    </form>
</div>

        <div class="airdrop-container">
            <?php while ($data = $gamedata->fetch_assoc()): ?>
            <div class="airdrop-item">
                
				<?php if (!empty($data['Title'])): ?>
				<h3><?php echo $data['Title']; ?></h3>
				<?php endif; ?>


				<?php if (!empty($data['Image'])): ?>
				<img src="../images/<?php echo strtolower(trim($data['GameAlias'])); ?>/<?php echo $data['Image']; ?>" alt="<?php echo $data['Title']; ?>">
				<?php endif; ?>

				<?php if (!empty($data['Description'])): ?>
                <p><?php echo $data['Description']; ?></p>
 				<?php endif; ?>

				<?php if (!empty($data['YoutubeLink'])): ?>
				Youtube Link: <a href="<?php echo $data['YoutubeLink']; ?>" target="_blank"><?php echo $data['YoutubeLink']; ?></a>
 				<?php endif; ?>
				<br>                
				<a href="gamedata.php?delete=<?php echo $data['ID']; ?>&gameid=<?php echo $data['GameID']; ?>">Xóa</a>
                <a href="gamedata.php?edit=<?php echo $data['ID']; ?>&gameid=<?php echo $data['GameID']; ?>">Sửa</a>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</body>
</html>

<?php $conn->close(); ?>
