<?php
	// Bật báo lỗi để xem lỗi chi tiết (chỉ sử dụng trong quá trình phát triển)
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
	include 'config.php';

    // Truy vấn để lấy dữ liệu từ bảng tongames
	$games = $conn->query("SELECT * FROM tongames");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Games on TON Blockchain</title>
	<link rel="stylesheet" type="text/css" href="css/tongame.css" />
</head>
<body>
    <h1>Games on TON Blockchain</h1>
    <div class="game-container">
        <?php foreach ($games as $game): ?>
        <div class="game-card">
            <img src="<?= htmlspecialchars($game['image']) ?>" alt="<?= htmlspecialchars($game['title']) ?>">
            <div class="game-info">
                <h3><span class="rating">★ <?= htmlspecialchars($game['rating']) ?></span> <?= htmlspecialchars($game['title']) ?></h3>
                <p><?= htmlspecialchars($game['description']) ?></p>
                <a href="<?= htmlspecialchars($game['alias']) ?>" class="reflink">Play Game</a>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</body>
</html>
