<?php
include 'config.php';

// Hàm trim và rename ảnh
function uploadImage($file, $alias) {
    $target_dir = "../images/" . strtolower(trim($alias)) . "/";
    
    // Kiểm tra và tạo thư mục nếu chưa tồn tại
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true);
    }

    $timestamp = time();
    $file_name = strtolower(trim($alias)) . "_" . $timestamp . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
    $target_file = $target_dir . $file_name;

    if (move_uploaded_file($file["tmp_name"], $target_file)) {
        return $target_file;
    } else {
        return null;
    }
}
function generateAlias($name) {
    // Chuyển thành chữ thường
    $alias = strtolower($name);
    // Thay thế các ký tự không phải chữ cái và số bằng dấu gạch ngang
    $alias = preg_replace('/[^a-z0-9]+/i', '-', trim($alias));
    // Loại bỏ các dấu gạch ngang ở đầu và cuối
    $alias = trim($alias, '-');
    return $alias;
}

// Thêm game
if (isset($_POST['add'])) {
    $name = $conn->real_escape_string($_POST['name']);
    //$alias = $conn->real_escape_string($_POST['alias']);
	$alias = generateAlias($name);
    $refLink = $conn->real_escape_string($_POST['reflink']);
    $logo = uploadImage($_FILES['logo'], $alias);

    if ($logo) {
        $sql = "INSERT INTO Games (GameName, GameAlias, GameLogo, RefLink) VALUES ('$name', '$alias', '$logo', '$refLink')";
        //$conn->query($sql);
		if ($conn->query($sql) === TRUE) {
			echo "Record updated successfully";
		} else {
			echo "Error updating record: " . $conn->error;
		}
    }
}

// Sửa game
if (isset($_POST['edit'])) {
    $id = $conn->real_escape_string($_POST['id']);
    $name = $conn->real_escape_string($_POST['name']);
    $alias = $conn->real_escape_string($_POST['alias']);
    $refLink = $conn->real_escape_string($_POST['reflink']);
    $logo = uploadImage($_FILES['logo'], $alias);

    if ($logo) {
        $sql = "UPDATE Games SET GameName='$name', GameAlias='$alias', GameLogo='$logo', RefLink='$refLink' WHERE GameID=$id";
    } else {
        $sql = "UPDATE Games SET GameName='$name', GameAlias='$alias', RefLink='$refLink' WHERE GameID=$id";
    }

    $conn->query($sql);
}

// Xóa game
if (isset($_GET['delete'])) {
    $id = $conn->real_escape_string($_GET['delete']);
    $sql = "DELETE FROM Games WHERE GameID=$id";
    $conn->query($sql);
}

// Hiển thị danh sách game
$games = $conn->query("SELECT * FROM Games");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Quản lý Game</title>
	<link rel="stylesheet" type="text/css" href="admin_styles.css" />
</head>
<body>
    <div class="container">
        <div class="form-container">
            <h1>Thêm/Sửa Game</h1>
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo isset($_GET['edit']) ? $_GET['edit'] : ''; ?>">
                <label>Tên Game:</label>
                <input type="text" name="name" required>
                <!--label>Alias:</label>
                <input type="text" name="alias" required-->
                <label>RefLink:</label>
                <input type="text" name="reflink">
                <label>Logo:</label>
                <input type="file" name="logo">
                <button type="submit" name="<?php echo isset($_GET['edit']) ? 'edit' : 'add'; ?>">
                    <?php echo isset($_GET['edit']) ? 'Sửa' : 'Thêm'; ?>
                </button>
            </form>
        </div>
        <div class="game-grid">
            <?php while ($game = $games->fetch_assoc()): ?>
            <div class="game-item">
                <img src="<?php echo $game['GameLogo']; ?>" alt="<?php echo $game['GameName']; ?>">
                <h3><?php echo $game['GameName']; ?></h3>
                <p><?php echo $game['RefLink']; ?></p>
                <a href="index.php?delete=<?php echo $game['GameID']; ?>">Xóa</a>
                <a href="index.php?edit=<?php echo $game['GameID']; ?>">Sửa</a><br/>
				<a href="gamedata.php?gameid=<?php echo $game['GameID']; ?>&add=<?php echo $game['GameID']; ?>">Thêm GameData</a> <!-- Nút thêm GameData -->
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</body>
</html>

<?php $conn->close(); ?>
