<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $image = null;

    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'images/airdrop_data/';
        $imageName = time() . '_' . basename($_FILES['image']['name']);
        $uploadFile = $uploadDir . $imageName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadFile)) {
            $image = $imageName;
        } else {
            echo "Đã xảy ra lỗi khi upload ảnh.";
        }
    }

    $stmt = $conn->prepare("INSERT INTO airdrop_data (title, image, description, created_at) VALUES (?, ?, ?, NOW())");
    $stmt->bind_param("sss", $title, $image, $description);
    $stmt->execute();
    $stmt->close();

    header("Location: manage_airdrop.php");
    exit();
}

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM airdrop_data WHERE ID = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();

    header("Location: manage_airdrop.php");
    exit();
}

$result = $conn->query("SELECT * FROM airdrop_data ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quản lý Airdrop</title>
    <link rel="stylesheet" href="css/styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        h1, h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        form {
            max-width: 600px;
            margin: 0 auto 20px;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        label {
            display: block;
            margin-bottom: 10px;
            font-weight: bold;
        }

        input[type="text"],
        textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="file"] {
            margin-bottom: 20px;
        }

        input[type="submit"] {
            padding: 10px 20px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #218838;
        }

        .airdrop-container {
            display: flex;
            flex-direction: column;
            gap: 10px;
            padding: 20px;
        }

        .airdrop-item {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 15px;
            align-items: left;
            justify-content: space-between;
        }

        .airdrop-item h3 {
            font-size: 18px;
            margin: 0;
        }

        .airdrop-item img {
            height: auto;
            margin-left: 20px;
            border-radius: 4px;
        }

        .airdrop-item p {
            font-size: 14px;
            color: #666;
            margin: 0;
            padding-left: 20px;
        }

        .airdrop-item a {
            margin-left: 20px;
            color: #007bff;
            text-decoration: none;
        }

        .airdrop-item a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <h1>Quản lý Airdrop</h1>

    <h2>Thêm Airdrop</h2>
    <form action="manage_airdrop.php" method="post" enctype="multipart/form-data">
        <label for="title">Tiêu đề:</label>
        <input type="text" name="title" id="title" required>
        
        <label for="description">Mô tả:</label>
        <textarea name="description" id="description" required></textarea>
        
        <label for="image">Ảnh (không bắt buộc):</label>
        <input type="file" name="image" id="image">
        
        <input type="submit" name="add" value="Thêm Airdrop">
    </form>

    <h2>Danh sách Airdrop</h2>
    <div class="airdrop-container">
        <?php while ($row = $result->fetch_assoc()) : ?>
            <div class="airdrop-item">
                <h3><?php echo $row['title']; ?></h3><br/>
                <?php if ($row['image']) : ?>
                    <img src="images/airdrop_data/<?php echo $row['image']; ?>" alt="<?php echo $row['title']; ?>"><br/>
                <?php endif; ?>
                <p><?php echo $row['description']; ?></p><br/>
                <a href="edit_airdrop.php?id=<?php echo $row['ID']; ?>">Sửa</a>
                <a href="manage_airdrop.php?delete=<?php echo $row['ID']; ?>" onclick="return confirm('Bạn có chắc muốn xóa?')">Xóa</a>
            </div>
        <?php endwhile; ?>
    </div>
</body>
</html>
