<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $image = $_POST['existing_image']; // Giữ nguyên ảnh hiện tại nếu không có ảnh mới

    // Kiểm tra nếu có file mới được upload
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'images/airdrop_data/';
        $imageName = time() . '_' . basename($_FILES['image']['name']);
        $uploadFile = $uploadDir . $imageName;

        // Di chuyển file mới vào thư mục
        if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadFile)) {
            $image = $imageName;
        } else {
            echo "Đã xảy ra lỗi khi upload ảnh mới.";
        }
    }

    // Cập nhật dữ liệu
    $stmt = $conn->prepare("UPDATE airdrop_data SET title = ?, image = ?, description = ? WHERE ID = ?");
    $stmt->bind_param("sssi", $title, $image, $description, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: manage_airdrop.php");
    exit();
}

// Lấy dữ liệu hiện tại để hiển thị
if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $stmt = $conn->prepare("SELECT * FROM airdrop_data WHERE ID = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sửa Airdrop</title>
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <h1>Sửa Airdrop</h1>
    <form action="edit_airdrop.php" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?php echo $row['ID']; ?>">
        <input type="hidden" name="existing_image" value="<?php echo $row['image']; ?>"> <!-- Giữ ảnh hiện tại -->

        <label for="title">Tiêu đề:</label>
        <input type="text" name="title" id="title" value="<?php echo $row['title']; ?>" required>
        
        <label for="description">Mô tả:</label>
        <textarea name="description" id="description" required><?php echo $row['description']; ?></textarea>
        
        <label for="image">Ảnh (để trống nếu không muốn thay đổi):</label>
        <input type="file" name="image" id="image">
        
        <input type="submit" name="edit" value="Cập nhật Airdrop">
    </form>
</body>
</html>
