<?php
include 'config.php';
// Kết nối tới cơ sở dữ liệu

// Xử lý thêm mới game
if (isset($_POST['add_game'])) {
    $gameName = $_POST['game_name'];
    $gameAlias = preg_replace('/[^a-z0-9]+/', '-', strtolower(trim($gameName)));
    $refLink = $_POST['ref_link'];

    // Tạo thư mục cho game nếu chưa tồn tại
    $targetDir = "images/$gameAlias/";
    if (!file_exists($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    // Xử lý upload ảnh logo và rename
    $timestamp = time();
    $targetFile = $targetDir . $gameAlias . $timestamp . basename($_FILES["game_logo"]["name"]);
    move_uploaded_file($_FILES["game_logo"]["tmp_name"], $targetFile);

    // Lưu dữ liệu vào bảng Games
    $stmt = $conn->prepare("INSERT INTO Games (GameName, GameAlias, GameLogo, RefLink) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $gameName, $gameAlias, $targetFile, $refLink);
    $stmt->execute();

    echo "Game đã được thêm thành công!";
}

// Xử lý cập nhật game
if (isset($_POST['update_game'])) {
    $gameID = $_POST['game_id'];
    $gameName = $_POST['game_name'];
    $gameAlias = preg_replace('/[^a-z0-9]+/', '-', strtolower(trim($gameName)));
    $refLink = $_POST['ref_link'];
    $targetDir = "images/$gameAlias/";

    // Cập nhật logo nếu có upload mới
    if (!empty($_FILES["game_logo"]["name"])) {
        $timestamp = time();
        $targetFile = $targetDir . $gameAlias . $timestamp . basename($_FILES["game_logo"]["name"]);
        move_uploaded_file($_FILES["game_logo"]["tmp_name"], $targetFile);
    } else {
        $targetFile = $_POST['existing_logo'];
    }

    // Cập nhật vào cơ sở dữ liệu
    $stmt = $conn->prepare("UPDATE Games SET GameName = ?, GameAlias = ?, GameLogo = ?, RefLink = ? WHERE GameID = ?");
    $stmt->bind_param("ssssi", $gameName, $gameAlias, $targetFile, $refLink, $gameID);
    $stmt->execute();

    echo "Game đã được cập nhật thành công!";
}

// Xử lý xóa game
if (isset($_GET['delete_game'])) {
    $gameID = $_GET['delete_game'];

    // Xóa dữ liệu trong bảng GameData trước
    $conn->query("DELETE FROM GameData WHERE GameID = $gameID");

    // Xóa game khỏi bảng Games
    $conn->query("DELETE FROM Games WHERE GameID = $gameID");

    echo "Game đã được xóa thành công!";
}
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quản lý Game</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            background: #fff;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
        img {
            max-width: 100%;
            height: auto;
        }
        h2, h3 {
            color: #333;
        }
        nav {
            background: #333;
            color: #fff;
            padding: 10px;
        }
        nav a {
            color: #fff;
            text-decoration: none;
            margin-right: 15px;
        }
    </style>
</head>
<body>
    <nav>
        <a href="index.php">Home</a>
    </nav>

    <div class="container">
        <h2>Add new Game</h2>
		<!-- Form thêm mới game -->
		<form method="POST" enctype="multipart/form-data">
			Tên Game: <input type="text" name="game_name" required><br>
			Logo Game: <input type="file" name="game_logo" required><br>
			Ref Link: <input type="text" name="ref_link"><br>
			<input type="submit" name="add_game" value="Thêm Game">
		</form>
	</div>

    <div class="container">
        <h2>Game List</h2>
        <?php
			$result = $conn->query("SELECT * FROM Games");
			while($row = $result->fetch_assoc()) {
				echo "<div>";
				echo "<a href='index.php?game_id=".$row['GameID']."'>";
				echo "<img src='".$row['GameLogo']."' alt='".$row['GameName']."' />";
				echo "<h3>".$row['GameName']."</h3>";
				echo "</a>";
				if (!empty($row['RefLink'])) {
					echo "<a href='".$row['RefLink']."' target='_blank'>Play this Game</a>";
				}
				echo "<a href='index.php?delete_game=".$row['GameID']."'>Delete</a>";
				echo "</div>";
			}       
		?>
    </div>

    <?php
    if (isset($_GET['game_id'])) {
        $gameID = $_GET['game_id'];
        $result = $conn->query("SELECT * FROM Games WHERE GameID = $gameID");
        $game = $result->fetch_assoc();
    ?>
    <div class="container">
        <h2>Edit Game</h2>
		<!-- Form sửa game -->
		<form method="POST" enctype="multipart/form-data">
			<input type="hidden" name="game_id" value="<?= $game['GameID'] ?>">
			Tên Game: <input type="text" name="game_name" value="<?= $game['GameName'] ?>" required><br>
			Logo Game: <input type="file" name="game_logo"><br>
			<input type="hidden" name="existing_logo" value="<?= $game['GameLogo'] ?>">
			Ref Link: <input type="text" name="ref_link" value="<?= $game['RefLink'] ?>"><br>
			<input type="submit" name="update_game" value="Cập nhật Game">
		</form>
	</div>
    <?php } ?>

</body>
</html>

<?php
// Đóng kết nối
$conn->close();
?>
