<?php

function getEthBnbAddress($seedPhrase) {
    // Chuyển seed phrase thành địa chỉ Ethereum / BNB
    // Cần sử dụng thư viện như web3-php hoặc phpecc
    return "0xYourGeneratedAddress";
}

function getSolAddress($seedPhrase) {
    // Chuyển seed phrase thành địa chỉ Solana
    return "YourGeneratedSolanaAddress";
}

function getSuiAddress($seedPhrase) {
    // Chuyển seed phrase thành địa chỉ SUI
    return "YourGeneratedSuiAddress";
}

function getBalance($address, $chain) {
    $urls = [
        "ETH" => "https://api.blockchair.com/ethereum/dashboards/address/$address",
        "BNB" => "https://api.blockchair.com/binance/dashboards/address/$address",
        "SOL" => "https://api.mainnet-beta.solana.com", // Cần gửi request JSON RPC
        "SUI" => "https://fullnode.mainnet.sui.io", // Cần gửi request JSON RPC
    ];
    
    if (!isset($urls[$chain])) return 0;
    
    $response = file_get_contents($urls[$chain]);
    $data = json_decode($response, true);
    
    if ($chain == "ETH" || $chain == "BNB") {
        return $data['data'][$address]['address']['balance'] / 1e18; // Đổi từ Wei sang ETH/BNB
    }
    
    return 0;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $seed = trim($_POST['seed']);
    $ethAddress = getEthBnbAddress($seed);
    $bnbAddress = getEthBnbAddress($seed);
    $solAddress = getSolAddress($seed);
    $suiAddress = getSuiAddress($seed);
    
    $balances = [
        "ETH" => getBalance($ethAddress, "ETH"),
        "BNB" => getBalance($bnbAddress, "BNB"),
        "SOL" => getBalance($solAddress, "SOL"),
        "SUI" => getBalance($suiAddress, "SUI"),
    ];
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Kiểm tra số dư ví</title>
</head>
<body>
    <form method="POST">
        <label>Nhập Seed Phrase:</label>
        <input type="text" name="seed" required>
        <button type="submit">Kiểm tra</button>
    </form>

    <?php if (!empty($balances)): ?>
        <h2>Kết quả:</h2>
        <ul>
            <?php foreach ($balances as $coin => $balance): ?>
                <li><strong><?php echo $coin; ?>:</strong> <?php echo $balance; ?></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</body>
</html>
