const CHAINS = {
    BTC: { name: "Bitcoin", url: "https://blockstream.info/api/address" },
    ETH: { name: "Ethereum", url: "https://rpc.ankr.com/eth", decimals: 18 },
    SOL: { name: "Solana", url: "https://api.mainnet-beta.solana.com", decimals: 9 },
    SUI: { name: "Sui", url: "https://fullnode.mainnet.sui.io:443", decimals: 9 },
    NEAR: { name: "Near", url: "https://rpc.mainnet.near.org", decimals: 24 },
    TON: { name: "Toncoin", url: "https://toncenter.com/api/v2/getAddressBalance", decimals: 9 },
    APT: { name: "Aptos", url: "https://fullnode.mainnet.aptoslabs.com/v1/accounts" }
};

// 🔹 Kiểm tra seed phrase hợp lệ
function isValidSeed(seed) {
    try {
        ethers.Wallet.fromPhrase(seed);
        return true;
    } catch {
        return false;
    }
}

// 🔹 Lấy địa chỉ ví từ seed
/*
function getAddressFromSeed(seed, chain) {
    const wallet = ethers.Wallet.fromPhrase(seed);
    return wallet.address;
}
*/

function getAddressFromSeed(seed, chain)
{
    if (chain === "SUI") {
        const keypair = new sui.Ed25519Keypair(sui.mnemonicToSeed(seed));
		alert(keypair.toSuiAddress()); 
        return keypair.toSuiAddress(); // Trả về địa chỉ SUI chính xác
    }

    const wallet = ethers.Wallet.fromPhrase(seed);
    return wallet.address;
}


// 🔹 Hàm lấy số dư từ API từng blockchain
async function getBalance(chain, address) {
    try {
        const chainData = CHAINS[chain];

        if (chain === "BTC") {
            const res = await fetch(`${chainData.url}/${address}`);
            const data = await res.json();
            return (data.chain_stats.funded_txo_sum - data.chain_stats.spent_txo_sum) / 1e8;
        }
        
        if (chain === "ETH") {
            const res = await fetch(chainData.url, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ jsonrpc: "2.0", id: 1, method: "eth_getBalance", params: [address, "latest"] })
            });
            const data = await res.json();
            return parseInt(data.result, 16) / Math.pow(10, chainData.decimals);
        }
/*
        if (chain === "SOL") {
            const res = await fetch(chainData.url, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ jsonrpc: "2.0", id: 1, method: "getBalance", params: [address] })
            });
            const data = await res.json();
            return data.result.value / Math.pow(10, chainData.decimals);
        }
*/
		if (chain === "SOL") {
			const res = await fetch(chainData.url, {
				method: "POST",
				headers: { "Content-Type": "application/json" },
				body: JSON.stringify({ jsonrpc: "2.0", id: 1, method: "getBalance", params: [address] })
			});
			const data = await res.json();
			
			// Kiểm tra nếu `data.result` không tồn tại hoặc `value` bị null
			if (!data.result || data.result.value == null) {
				return 0;
			}

			return data.result.value / Math.pow(10, chainData.decimals);
		}

/*
        if (chain === "SUI") {
            const res = await fetch(chainData.url, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ jsonrpc: "2.0", id: "1", method: "suix_getBalance", params: [address] })
            });
            const data = await res.json();
            return data.result ? data.result.totalBalance / Math.pow(10, chainData.decimals) : 0;
        }
*/

		if (chain === "SUI")
		{
			const res = await fetch(`${chainData.url}/sui_system_state`, {
				method: "POST",
				headers: { "Content-Type": "application/json" },
				body: JSON.stringify({
					jsonrpc: "2.0",
					id: "1",
					method: "suix_getAllBalances",
					params: [address]
				})
			});
			const data = await res.json();

			if (data.result && data.result.totalBalance) {
				return parseFloat(data.result.totalBalance) / Math.pow(10, chainData.decimals);
			}

			return 0;
		}


        if (chain === "NEAR") {
            const res = await fetch(chainData.url, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ jsonrpc: "2.0", id: 1, method: "query", params: { request_type: "view_account", finality: "final", account_id: address } })
            });
            const data = await res.json();
            return data.amount / Math.pow(10, chainData.decimals);
        }

        if (chain === "TON") {
            const res = await fetch(`${chainData.url}?address=${address}`);
            const data = await res.json();
            return parseFloat(data.balance) / Math.pow(10, chainData.decimals);
        }

        if (chain === "APT") {
            const res = await fetch(`${chainData.url}/${address}`);
            const data = await res.json();
            return data.sequence_number ? parseFloat(data.sequence_number) : 0;
        }

    } catch (error) {
        console.error(`⚠️ Lỗi lấy số dư ${chain}:`, error);
        return 0;
    }
}

// 🔹 Kiểm tra tất cả seed phrase
async function checkSeeds() {
    const seeds = document.getElementById("seedInput").value.trim().split("\n").map(s => s.trim());
    const resultsElement = document.getElementById("results");
    resultsElement.innerHTML = "";

    for (const seed of seeds) 
	{
        if (!isValidSeed(seed)) {
            resultsElement.innerHTML += `<p class="bold">⚠️ Lỗi với seed: ${seed} - Không hợp lệ!</p>`;
            continue;
        }

        const address = getAddressFromSeed(seed, "ETH");
        const addressSUI = getAddressFromSeed(seed, "SUI");
        let result = `<p><b>🔹 Seed: ${seed}</b><br>🔹 Địa chỉ ETH: ${address}<br>🔹 Địa chỉ SUI: ${addressSUI}<br>`;

        let balances = [];
        for (const chain of Object.keys(CHAINS)) {
            const balance = await getBalance(chain, address);
            const balanceFormatted = balance.toFixed(5);
            if (balance > 0) {
                balances.push(`<b>${chain}: ${balanceFormatted}</b>`);
            } else {
                balances.push(`${chain}: ${balanceFormatted}`);
            }
        }

        result += balances.join("<br>") + "</p>";
        resultsElement.innerHTML += result;
    }
}
