<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gửi Request và Hiển thị Kết quả</title>
</head>
<body>

    <h2>Nhập thông tin và Gửi Request</h2>

    <form method="POST" action="" id="requestForm">
        <label for="url">URL:</label><br>
        <input type="text" id="url" name="url" placeholder="Nhập URL" required><br><br>

        <label for="headers">Headers (JSON format):</label><br>
        <textarea id="headers" name="headers" placeholder='{"Authorization": "Bearer your_token"}' required></textarea><br><br>

        <label for="userId">User ID:</label><br>
        <input type="text" id="userId" name="userId" placeholder="Nhập User ID" required><br><br>

        <label for="userName">User Name:</label><br>
        <input type="text" id="userName" name="userName" placeholder="Nhập User Name" required><br><br>

        <button type="submit">Gửi Request</button>
    </form>

    <h3>Kết quả:</h3>
    <div id="result"></div>

    <script>
        document.getElementById('requestForm').onsubmit = function(e) {
            e.preventDefault(); // Ngăn chặn form nộp tự động

            const url = document.getElementById('url').value;
            const userId = document.getElementById('userId').value;
            const userName = document.getElementById('userName').value;
            const headersInput = document.getElementById('headers').value;

            let headers;
            try {
                headers = JSON.parse(headersInput);
            } catch (e) {
                alert('Định dạng headers không hợp lệ. Vui lòng nhập đúng định dạng JSON.');
                return;
            }

            // Gửi yêu cầu POST tới server PHP proxy
            fetch('proxy.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    url: url,
                    userId: userId,
                    userName: userName,
                    headers: headers
                })
            })
            .then(response => response.json())
            .then(data => {
                // Lưu dữ liệu trả về vào sessionStorage
                sessionStorage.setItem('responseData', JSON.stringify(data));

                // Hiển thị kết quả
                const sessionData = sessionStorage.getItem('responseData');
                document.getElementById('result').innerText = `Dữ liệu trong sessionStorage: ${sessionData}`;
            })
            .catch(error => {
                document.getElementById('result').innerText = `Lỗi: ${error.message}`;
            });
        };
    </script>

</body>
</html>
