<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputData = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($inputData['url']) || !isset($inputData['userId']) || !isset($inputData['userName']) || !isset($inputData['headers'])) {
        echo json_encode(['error' => 'Thiếu dữ liệu đầu vào.']);
        exit;
    }

    $url = $inputData['url'];
    $userId = $inputData['userId'];
    $userName = $inputData['userName'];
    $headers = $inputData['headers'];

    $ch = curl_init();
    
    // Thiết lập headers
    $curlHeaders = [];
    foreach ($headers as $key => $value) {
        $curlHeaders[] = "$key: $value";
    }

    $postData = [
        'userId' => $userId,
        'userName' => $userName
    ];

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeaders);

    // Tự động xử lý nén gzip, deflate
    curl_setopt($ch, CURLOPT_ENCODING, "");

    // Thực hiện yêu cầu
    $response = curl_exec($ch);

    // Kiểm tra lỗi cURL
    if (curl_errno($ch)) {
        echo json_encode(['error' => 'Lỗi cURL: ' . curl_error($ch)]);
    } else {
        // Kiểm tra nội dung có phải là JSON hợp lệ
        $json_response = json_decode($response, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            echo $response;
        } else {
            echo json_encode(['error' => 'Phản hồi không phải JSON hợp lệ']);
        }
    }

    curl_close($ch);
} else {
    echo json_encode(['error' => 'Yêu cầu không hợp lệ']);
}
