<?php

// Thư viện Chart.js
echo '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>';

// Lấy dữ liệu giá Bitcoin từ Binance API
$apiUrl = 'https://api.binance.com/api/v3/klines';
$symbol = 'BTCUSDT'; // Cặp giao dịch Bitcoin/USDT
$interval = '1h'; // Khoảng thời gian giữa các nến (1 giờ)
$limit = 24; // Số lượng nến cần lấy (24 giờ)

$url = "{$apiUrl}?symbol={$symbol}&interval={$interval}&limit={$limit}";

// Gửi yêu cầu GET đến Binance API
$response = file_get_contents($url);
$data = json_decode($response, true);

// Chuẩn bị dữ liệu cho biểu đồ
$timestamps = [];
$prices = [];

foreach ($data as $candle) {
    $timestamps[] = $candle[0] / 1000; // Chuyển đổi timestamp về giây
    $prices[] = $candle[4]; // Giá đóng cửa
}

// Tạo canvas cho biểu đồ
echo '<canvas id="bitcoinChart" width="800" height="400"></canvas>';

// Script JavaScript để vẽ biểu đồ
echo '<script>';
echo 'var ctx = document.getElementById("bitcoinChart").getContext("2d");';
echo 'var chart = new Chart(ctx, {';
echo '    type: "line",';
echo '    data: {';
echo '        labels: ' . json_encode($timestamps) . ',';
echo '        datasets: [{';
echo '            label: "Bitcoin Price",';
echo '            data: ' . json_encode($prices) . ',';
echo '            backgroundColor: "rgba(75, 192, 192, 0.2)",';
echo '            borderColor: "rgba(75, 192, 192, 1)",';
echo '            borderWidth: 1';
echo '        }]';
echo '    },';
echo '    options: {';
echo '        scales: {';
echo '            x: {';
echo '                type: "time",';
echo '                time: {';
echo '                    unit: "hour"';
echo '                }';
echo '            }';
echo '        }';
echo '    }';
echo '});';
echo '</script>';

?>
