<section class="content">
	<ol class="breadcrumb">
		<li><a href="dashboard.php">Dashboard</a></li>
		<li><a href="manage-video.php">Manage Video</a></li>
		<li class="active">Add Video</a></li>
	</ol>
   <div class="container-fluid">
		<div class="row clearfix">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<form id="form_validation" method="post" enctype="multipart/form-data">
					<div class="card">
						<div class="header">
							<h2>ADD VIDEO</h2>
							<button type="submit" name="submit" class="btn bg-blue waves-effect pull-right">PUBLISH</button>
						</div>
						<div class="body">
							<div class="row clearfix">
								<div class="col-sm-5">
									<div class="form-group">
										<div class="font-12">Category ID</div>
										<div class="form-line"><input type="text" class="form-control" name="category_id" id="category_id" required></div>
									</div>
									<div class="form-group">
										<div class="font-12">Videos list</div>
										<div class="form-line"><textArea type="textarea" name="YoutubeList" id="YoutubeList" class="form-control" required cols="50" rows="20"></textarea></div>
									</div>
								</div>
								<div class="col-sm-7">
									<button type="submit" name="submit" class="btn bg-blue waves-effect pull-right">PUBLISH</button>
								</div>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</section>
<?php 
    include('public/fcm.php');
    require_once("public/thumbnail_images.class.php");
	$cat_id = "";
	$video_title = "";
	$video_url = "";
	$video_id = "";
	$video_thumbnail = "";
	$video_duration = "";
	$video_description = "";
	$video_type = "";
	$size = "";
	$total_views = "";

	function convtime($youtube_time){
		$start = new DateTime('@0'); // Unix epoch
		$start->add(new DateInterval($youtube_time));
		return $start->format('H:i:s');
	}   

	function youtube_id_from_url($url)
	{
		$pattern = 
		'%^# Match any youtube URL
		(?:https?://)?  # Optional scheme. Either http or https
		(?:www\.)?      # Optional www subdomain
		(?:             # Group host alternatives
		  youtu\.be/    # Either youtu.be,
		| youtube\.com  # or youtube.com
		  (?:           # Group path alternatives
			/embed/     # Either /embed/
		  | /v/         # or /v/
		  | /watch\?v=  # or /watch\?v=
		  )             # End path alternatives.
		)               # End host alternatives.
		([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
		$%x'
		;

		//$url = "http://www.youtube.com/watch?v=C4kxS1ksqtw&feature=relate";
		parse_str( parse_url( $url, PHP_URL_QUERY ), $my_array_of_vars );
		//echo $my_array_of_vars['v'];  

		$result = preg_match($pattern, $url, $matches);

		if (false !== $result) {
			//return $matches[1];
			return $my_array_of_vars['v'];
		}
		return false;
	}
	function YoutubeVideoInfo($video_id)
	{
		$url = 'https://www.googleapis.com/youtube/v3/videos?id='.$video_id.'&key=AIzaSyDSSaeizxkwZv88ZxEFY5Q-MGPMxqbYobo&part=snippet,contentDetails,statistics,status';
		//$url = 'https://www.googleapis.com/youtube/v3/videos?id="+videoId+"&key=AIzaSyDSSaeizxkwZv88ZxEFY5Q-MGPMxqbYobo&part=snippet,contentDetails,statistics,status';
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$response = curl_exec($ch);
		curl_close($ch);
		$response_a = json_decode($response);
		print_r($response_a);// if you want to get all video details
		return  $response_a;//->items[0]->snippet->title; //get video duaration
	}
	//passing youtube videoId to function 
	//YoutubeVideoInfo('DDtDRFvB49M');

    if(isset($_POST['submit']))
	{
		$input = $_POST['YoutubeList'];

		//I dont check for empty() incase your app allows a 0 as ID.
		if (strlen($input)==0) 
		{
			echo 'no input';
			exit;
		}
		$YoutubeList = explode("\n", str_replace("\r", "", $input));

		for($i=0; $i<count($YoutubeList); $i++)
		{
			$video_id = youtube_id_from_url($YoutubeList[$i]);
			$VideoInfo = YoutubeVideoInfo($video_id);

			$data = array(
				'cat_id'            => $_POST['category_id'],
				'video_title'       => $VideoInfo->items[0]->snippet->title,
				'video_url'         => $YoutubeList[$i],
				'video_id'          => $video_id,
				'video_thumbnail'   => '',
				'video_duration'    => convtime($VideoInfo->items[0]->contentDetails->duration),
				'video_description' => $VideoInfo->items[0]->snippet->description,
				'video_type'        => 'youtube',
				'size'              => '',
				'total_views'		=> $VideoInfo->items[0]->statistics->viewCount,
				'date_time'		=> $VideoInfo->items[0]->snippet->publishedAt
				);

				$qry = Insert('tbl_gallery', $data);
			//print_r($VideoInfo);
			echo $video_id.'---'.$_POST['category_id'].'---'.$VideoInfo->items[0]->snippet->title.'---'.convtime($VideoInfo->items[0]->contentDetails->duration).'---'.$VideoInfo->items[0]->snippet->description.'---'.$VideoInfo->items[0]->statistics->viewCount.'---'.$VideoInfo->items[0]->snippet->publishedAt.'<br>';//->snippet->title;
		}
		//$_SESSION['msg'] = $msg_ss;
		//header( "Location:add-video.php?cat_id=".$_POST['cat_id']);
		exit;
    }
    $wall_qry = "SELECT * FROM tbl_category";
    $wall_result = mysqli_query($connect, $wall_qry);
?>
	<script type="text/javascript">
	//Parse ID from url
	function youtube_parser(url){
		var regExp = /^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/;
		var match = url.match(regExp);
		return (match&&match[7].length==11)? match[7] : false;
	}
	
	//Convert youtube duration to time format
	function covtime(youtube_time)
	{
		array = youtube_time.match(/(\d+)(?=[MHS])/ig)||[]; 
		if(youtube_time.indexOf('M')>0)
		{
			if(array.length == 3)
			{
				var formatted = array.map(function(item)
				{
					if(item.length<2) return '0'+item;
					return item;
				}).join(':');
				return formatted;
			}
			if(array.length == 2)
			{
				var formatted = array.map(function(item)
				{
					if(item.length<2) return '0'+item;
					return item;
				}).join(':');

				if(youtube_time.indexOf("S")>0)
				{
					return formatted;
				}
				else
				{
					return formatted+":00";
				}
			}
			else
			{
				var formatted = array.map(function(item)
				{
					if(item.length<2) return '0'+item;
					return item;
				}).join(':');
				return formatted;
			}
		}
		else
		{
			if(array.length == 2)
			{
				var formatted = array.map(function(item)
				{
					if(item.length<2) return '0'+item;
					return item;
				}).join(':00:');
				return formatted;
			}
		}
	}

	//Set title textbox
			  //url: "https://www.googleapis.com/youtube/v3/videos?id="+videoId+"&key=AIzaSyBfFYLiPW3rTXxULRuT9LaepU1lwgDpbEY&part=snippet,contentDetails,statistics,status", 
	function setTitle(videoId)
	{
		$.ajax({
			  url: "https://www.googleapis.com/youtube/v3/videos?id="+videoId+"&key=AIzaSyDSSaeizxkwZv88ZxEFY5Q-MGPMxqbYobo&part=snippet,contentDetails,statistics,status", 
			  dataType: "jsonp",
			  success: function(data){
					   $("#video_title").val(data.items[0].snippet.title);
					   $("#video_duration").val(covtime(data.items[0].contentDetails.duration));

					   var editor = CKEDITOR.instances['video_description'];
					   editor.setData(data.items[0].snippet.description);

					   console.log(data.items[0].snippet.title + " - " +covtime(data.items[0].contentDetails.duration));
			  },
			  error: function(jqXHR, textStatus, errorThrown) {
				  alert (textStatus, + ' | ' + errorThrown);
			  }
		});
	}

    $(document).ready(function(e) 
	{
        $("#youtube #youtube").change(function()
		{
			var videoUrl = $("#youtube #youtube").val();
			setTitle(youtube_parser(videoUrl));
			//alert(youtube_parser(videoUrl));

		});

        $("#upload_type").change(function()
		{
            var type = $("#upload_type").val();

			if (type == "youtube") {
				$("#video_upload").hide();
				$("#direct_url").hide();
				$("#youtube").show();
			}

			if (type == "Url") {
				$("#youtube").hide();
				$("#video_upload").hide();
				$("#direct_url").show();
			}

			if (type == "Upload") {
				$("#youtube").hide();
				$("#direct_url").hide();
				$("#video_upload").show();
			}                       
        });

        $( window ).load(function() {
        var type=$("#upload_type").val();

            if (type == "youtube")  {
                $("#video_upload").hide();
                $("#direct_url").hide();
                $("#youtube").show();
            }

            if (type == "Url") {
                $("#youtube").hide();
                $("#video_upload").hide();
                $("#direct_url").show();
            }

            if (type == "Upload") {
                $("#youtube").hide();
                $("#direct_url").hide();
                $("#video_upload").show();
            }
        });
    });
</script>
