<?php
// URL API của Binance
echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>';
echo '<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">';
$url = 'https://api.binance.com/api/v3/klines';
// Thông tin các tham số yêu cầu
$symbols = ['DOGEUSDT', 'SHIBUSDT', 'PEPEUSDT', 'WIFUSDT', 'TURBOUSDT', 'GOATUSDT', 'NEIROCTOUSDT'];
//$symbols = ['TRXUSDT', 'FILUSDT', 'VETUSDT', 'CFXUSDT', 'FLOWUSDT', 'NEOUSDT', 'IMXUSDT', 'DYDXUSDT', 'CAKEUSDT', 'JSTUSDT', 'ONTUSDT', 'SUSHIUSDT', 'ACHUSDT', 'IOSTUSDT', 'CKBUSDT', 'MOBUSDT', 'STGUSDT', 'COCOSUSDT', 'NKNUSDT', 'HOOKUSDT', 'CTKUSDT', 'LINAUSDT', 'DODOUSDT', 'QKCUSDT', 'SUNUSDT', 'IRISUSDT', 'GHSTUSDT', 'WANUSDT', 'FLMUSDT', 'CTXCUSDT', 'KEYUSDT', 'TVKUSDT', 'YFIIUSDT', 'MDTUSDT', 'ERNUSDT', 'PHBUSDT', 'LEVERUSDT', 'DFUSDT', 'APXUSDT', 'VITEUSDT', 'FORUSDT', 'WTCUSDT', 'QLCUSDT'];
$interval = '1w'; // Khoảng thời gian mỗi cây nến (1w - 1 tuần)
$limit = 52; // Số lượng cây nến (52 tuần)

// Vẽ biểu đồ cho mỗi coin
foreach ($symbols as $symbol) 
{
    // Tạo URL yêu cầu cho từng coin
    $queryParams = http_build_query([
        'symbol' => $symbol,
        'interval' => $interval,
        'limit' => $limit,
    ]);
    $requestUrl = $url . '?' . $queryParams;

    // Gửi yêu cầu HTTP đến API Binance
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $requestUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Chuyển đổi dữ liệu nhận được thành mảng
    $data = json_decode($response, true);

    // Tạo mảng chứa giá trị giá và thời gian
    $prices = [];
    $timestamps = [];
    foreach ($data as $item) {
        $prices[] = $item[4]; // Giá đóng cửa
        $timestamps[] = $item[0]; // Thời gian
    }

    // Tạo ID duy nhất cho biểu đồ
    $chartId = strtolower($symbol) . 'Chart';

    // In thẻ canvas cho biểu đồ
	echo $symbol;
    echo '<canvas id="' . $chartId . '" width="1024" height="200"></canvas>';

    // In mã JavaScript tạo biểu đồ
    echo '<script>';
    echo 'var ctx = document.getElementById("' . $chartId . '").getContext("2d");';
    echo 'var chart = new Chart(ctx, {';
    echo '    type: "line",';
    echo '    data: {';
    echo '        labels: ' . json_encode($timestamps) . ',';
    echo '        datasets: [{';
    echo '            label: "' . $symbol . '",';
    echo '            data: ' . json_encode($prices) . ',';
    echo '            backgroundColor: "rgba(0, 123, 255, 0.3)",';
    echo '            borderColor: "rgba(0, 123, 255, 0.8)",';
    echo '            borderWidth: 1,';
    echo '            pointRadius: 0';
    echo '        }]';
    echo '    },';
    echo '    options: {';
    echo '        responsive: true,';
    echo '        scales: {';
    echo '            x: {';
    echo '                type: "time",';
    echo '                time: {';
    echo '                    unit: "week"';
    echo '                },';
    echo '                ticks: {';
    echo '                    source: "auto"';
    echo '                }';
    echo '            },';
    echo '            y: {';
    echo '                ticks: {';
    echo '                    beginAtZero: false';
    echo '                }';
    echo '            }';
    echo '        }';
    echo '    }';
    echo '});';
    echo '</script>';
}
?>
