const express = require('express');
const axios = require('axios');
const app = express();
app.use(express.json());

// Route để nhận yêu cầu từ PHP và gửi request đến OKX
app.post('/fetch_okx_data', async (req, res) => {
    const { url, userId, userName } = req.body;

    try {
        // Thiết lập request headers và payload
        const headers = {
            "Accept": "application/json",
            "Content-Type": "application/json",
            "User-Agent": "Mozilla/5.0"
        };
        const payload = {
            extUserId: userId,
            extUserName: userName,
            gameId: 1,
            linkCode: "31347852"
        };

        // Gửi yêu cầu đến OKX API
        const response = await axios.post(url, payload, { headers });
        res.json(response.data);  // Trả về dữ liệu từ OKX cho PHP
    } catch (error) {
        console.error('Error fetching data from OKX:', error);
        res.status(500).json({ error: 'Có lỗi trong quá trình lấy dữ liệu từ OKX.' });
    }
});

// Chạy Node.js server
app.listen(3000, () => {
    console.log('Node.js server is running on http://localhost:3000');
});
