<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OKX API Interaction</title>
    <script>
        // Hàm gửi request đến server PHP (fetch_okx.php)
        async function fetchDataFromOKX() {
            const url = document.getElementById('url').value;
            const userId = document.getElementById('userId').value;
            const userName = document.getElementById('userName').value;

            try {
                // Gửi yêu cầu đến PHP proxy
                const response = await fetch('fetch_okx.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ url, userId, userName })
                });
                
                const data = await response.json();
                
                // Lưu phản hồi vào sessionStorage
                sessionStorage.setItem('okxResponse', JSON.stringify(data));

                // Hiển thị dữ liệu từ sessionStorage
                document.getElementById('result').innerText = sessionStorage.getItem('okxResponse');
            } catch (error) {
                console.error('Lỗi:', error);
                document.getElementById('result').innerText = 'Lỗi trong quá trình lấy dữ liệu.';
            }
        }
    </script>
</head>
<body>

    <h2>Gửi Request đến OKX</h2>
    <label for="url">OKX API URL:</label><br>
    <input type="text" id="url" placeholder="https://www.okx.com/api/v5/..."><br><br>

    <label for="userId">User ID:</label><br>
    <input type="text" id="userId" placeholder="Nhập User ID"><br><br>

    <label for="userName">User Name:</label><br>
    <input type="text" id="userName" placeholder="Nhập User Name"><br><br>

    <button onclick="fetchDataFromOKX()">Lấy Dữ Liệu</button>

    <h3>Kết quả:</h3
