<?php
function fetch_html($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
        CURLOPT_TIMEOUT => 10,
    ]);
    $html = curl_exec($ch);
    if (curl_errno($ch)) {
        echo "cURL error: " . curl_error($ch);
        return false;
    }
    curl_close($ch);
    return $html;
}

function parse_coindesk() {
    $url = 'https://www.coindesk.com/';
    $html = fetch_html($url);
    if (!$html) return [];

    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query("//a[contains(@class, 'card-title')]");
    $items = [];
    foreach ($nodes as $node) {
        $title = trim($node->textContent);
        $link = $node->getAttribute('href');
        if (strpos($link, 'http') !== 0) {
            $link = 'https://www.coindesk.com' . $link;
        }
        $items[] = ['title' => $title, 'link' => $link];
        if (count($items) >= 5) break;
    }
    return $items;
}

function parse_cointelegraph() {
    $url = 'https://cointelegraph.com/';
    $html = fetch_html($url);
    if (!$html) return [];

    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query("//a[contains(@class, 'post-card-inline__title-link')]");
    $items = [];
    foreach ($nodes as $node) {
        $title = trim($node->textContent);
        $link = $node->getAttribute('href');
        if (strpos($link, 'http') !== 0) {
            $link = 'https://cointelegraph.com' . $link;
        }
        $items[] = ['title' => $title, 'link' => $link];
        if (count($items) >= 5) break;
    }
    return $items;
}

function parse_cryptoslate() {
    $url = 'https://cryptoslate.com/';
    $html = fetch_html($url);
    if (!$html) return [];

    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query("//a[contains(@class, 'tw-block') and contains(@class, 'tw-text-lg')]");
    $items = [];
    foreach ($nodes as $node) {
        $title = trim($node->textContent);
        $link = $node->getAttribute('href');
        if (strpos($link, 'http') !== 0) {
            $link = 'https://cryptoslate.com' . $link;
        }
        $items[] = ['title' => $title, 'link' => $link];
        if (count($items) >= 5) break;
    }
    return $items;
}

$coindesk = parse_coindesk();
$cointelegraph = parse_cointelegraph();
$cryptoslate = parse_cryptoslate();
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Tin Tức Crypto</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        nav a { margin-right: 15px; text-decoration: none; color: #333; }
        section { margin-top: 20px; }
        h2 { color: #0066cc; }
        ul { list-style-type: none; padding: 0; }
        li { margin-bottom: 10px; }
    </style>
</head>
<body>
    <nav>
        <a href="#coindesk">CoinDesk</a>
        <a href="#cointelegraph">CoinTelegraph</a>
        <a href="#cryptoslate">CryptoSlate</a>
    </nav>

    <section id="coindesk">
        <h2>CoinDesk</h2>
        <ul>
            <?php foreach ($coindesk as $item): ?>
                <li><a href="<?= htmlspecialchars($item['link']) ?>" target="_blank"><?= htmlspecialchars($item['title']) ?></a></li>
            <?php endforeach; ?>
        </ul>
    </section>

    <section id="cointelegraph">
        <h2>CoinTelegraph</h2>
        <ul>
            <?php foreach ($cointelegraph as $item): ?>
                <li><a href="<?= htmlspecialchars($item['link']) ?>" target="_blank"><?= htmlspecialchars($item['title']) ?></a></li>
            <?php endforeach; ?>
        </ul>
    </section>

    <section id="cryptoslate">
        <h2>CryptoSlate</h2>
        <ul>
            <?php foreach ($cryptoslate as $item): ?>
                <li><a href="<?= htmlspecialchars($item['link']) ?>" target="_blank"><?= htmlspecialchars($item['title']) ?></a></li>
            <?php endforeach; ?>
        </ul>
    </section>
</body>
</html>
