<?php
include 'administrator/config.php';
// Kết nối tới cơ sở dữ liệu

// Lấy GameID từ URL
$gameID = isset($_GET['gameid']) ? $conn->real_escape_string($_GET['gameid']) : null;

// Xây dựng câu truy vấn SQL
$sql = "SELECT gd.*, g.* FROM GameData gd LEFT JOIN Games g ON gd.GameID = g.GameID";

// Nếu có tham số GameID, thêm điều kiện vào câu truy vấn
if ($gameID) {
    $sql .= " WHERE gd.GameID = '$gameID'";
}

// Thực thi truy vấn
$gamedata = $conn->query($sql);

?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quản lý Game</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            background: #fff;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
        img {
            max-width: 100%;
            height: auto;
        }
        h2, h3 {
            color: #333;
        }
        nav {
            background: #333;
            color: #fff;
            padding: 10px;
        }
        nav a {
            color: #fff;
            text-decoration: none;
            margin-right: 15px;
        }
    </style>
</head>
<body>
    <nav>
        <a href="index.php">Home</a>
    </nav>

    <div class="container">
        <h2>Add new Game</h2>
		<!-- Form thêm mới game -->
		<form method="POST" enctype="multipart/form-data">
			Tên Game: <input type="text" name="game_name" required><br>
			Logo Game: <input type="file" name="game_logo" required><br>
			Ref Link: <input type="text" name="ref_link"><br>
			<input type="submit" name="add_game" value="Thêm Game">
		</form>
	</div>

    <div class="container">
        <h2>Game List</h2>
        <?php
			$result = $conn->query("SELECT * FROM Games");
			while($row = $result->fetch_assoc()) {
				echo "<div>";
				echo "<a href='index.php?game_id=".$row['GameID']."'>";
				echo "<img src='".$row['GameLogo']."' alt='".$row['GameName']."' />";
				echo "<h3>".$row['GameName']."</h3>";
				echo "</a>";
				if (!empty($row['RefLink'])) {
					echo "<a href='".$row['RefLink']."' target='_blank'>Play this Game</a>";
				}
				echo "<a href='index.php?delete_game=".$row['GameID']."'>Delete</a>";
				echo "</div>";
			}       
		?>
    </div>

    <?php
    if (isset($_GET['game_id'])) {
        $gameID = $_GET['game_id'];
        $result = $conn->query("SELECT * FROM Games WHERE GameID = $gameID");
        $game = $result->fetch_assoc();
    ?>
    <div class="container">
        <h2>Edit Game</h2>
		<!-- Form sửa game -->
		<form method="POST" enctype="multipart/form-data">
			<input type="hidden" name="game_id" value="<?= $game['GameID'] ?>">
			Tên Game: <input type="text" name="game_name" value="<?= $game['GameName'] ?>" required><br>
			Logo Game: <input type="file" name="game_logo"><br>
			<input type="hidden" name="existing_logo" value="<?= $game['GameLogo'] ?>">
			Ref Link: <input type="text" name="ref_link" value="<?= $game['RefLink'] ?>"><br>
			<input type="submit" name="update_game" value="Cập nhật Game">
		</form>
	</div>
    <?php } ?>

</body>
</html>

<?php
// Đóng kết nối
$conn->close();
?>
