<?php
function fetch_url($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $html = curl_exec($ch);
    curl_close($ch);
    return $html;
}

// Nếu có ?url → hiển thị chi tiết bài viết
if (isset($_GET['url'])) {
    $url = $_GET['url'];
    $html = fetch_url($url);

    libxml_use_internal_errors(true);
    $doc = new DOMDocument();
    @$doc->loadHTML($html);
    $xpath = new DOMXPath($doc);

    // Lấy nội dung bài viết từ article chính
    $nodes = $xpath->query('//*[@id="__next"]/main/div[1]/div[1]/div[1]/div/article');

    echo '<a href="index.php" style="display:block;margin:20px 0;">← Quay lại</a>';
    echo '<div style="max-width:800px;margin:auto;font-family:sans-serif;padding:20px;">';
    if ($nodes && $nodes->length > 0) {
        echo $doc->saveHTML($nodes->item(0));
    } else {
        echo "<p>Không thể hiển thị nội dung bài viết.</p>";
    }
    echo '</div>';
    exit;
}

// Nếu không có ?url → lấy danh sách từ RSS
$rss_url = "https://crypto.news/feed/";
$rss_data = fetch_url($rss_url);

$items = [];
if ($rss_data) {
    $rss = new SimpleXMLElement($rss_data);
    foreach ($rss->channel->item as $item) {
        $ns = $item->children('media', true); // để lấy ảnh
        $items[] = [
            'title' => (string) $item->title,
            'link' => (string) $item->link,
            'image' => isset($ns->content) ? (string) $ns->content->attributes()->url : null
        ];
        if (count($items) >= 9) break; // Lấy 9 bài mới nhất
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Tin tức Crypto</title>
    <style>
        body { font-family: sans-serif; background: #f4f4f4; margin: 0; padding: 0; }
        h1 { text-align: center; padding: 20px; }
        .grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            padding: 20px;
            max-width: 1200px;
            margin: auto;
        }
        .card {
            background: white;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            text-align: center;
            transition: 0.2s;
        }
        .card:hover { transform: translateY(-5px); }
        .card img {
            width: 100%;
            height: 150px;
            object-fit: cover;
            border-radius: 4px;
        }
        .card a {
            display: block;
            margin-top: 10px;
            font-weight: bold;
            color: #333;
            text-decoration: none;
        }
        .card a:hover { color: #007bff; }
    </style>
</head>
<body>
    <h1>Tin tức Crypto mới nhất</h1>
    <div class="grid">
        <?php foreach ($items as $item): ?>
            <div class="card">
                <?php if ($item['image']): ?>
                    <img src="<?= htmlspecialchars($item['image']) ?>" alt="Ảnh">
                <?php endif; ?>
                <a href="index.php?url=<?= urlencode($item['link']) ?>"><?= htmlspecialchars($item['title']) ?></a>
            </div>
        <?php endforeach; ?>
    </div>
</body>
</html>
