function updateProgressBar(percent)
{
	const progressBar = document.getElementById('progress-bar');
	progressBar.style.width = `${percent}%`;
	progressBar.innerText = `${percent}%`;
}

async function generatePromoCodes(appToken, promoId)
{
	//updateProgressBar(5);
	const button = document.getElementById("generateButton");
	button.disabled = true;

	for (let i = 1; i <= 4; i++) 
	{
		//updateProgressBar(10);
		const promoCodeInput = document.getElementById(`promoCode${i}`);
		const copyButton = document.getElementById(`copyButton${i}`);
		const promoCodeContainer = document.getElementById(`promoCodeContainer${i}`);

		if (!promoCodeInput || !copyButton || !promoCodeContainer) {
			console.error('Required elements are missing.');
			return;
		}

		promoCodeInput.classList.add("d-none");
		copyButton.classList.add("d-none");
		promoCodeInput.value = "";
		promoCodeContainer.style.display = 'none';
		//updateProgressBar(15);
		try
		{
			//updateProgressBar(20);
			const progressIncrement = 25; // Increment by 25% for each promo code
			const promoCode = await completePromoCodeGeneration(appToken, promoId);
			promoCodeInput.value = promoCode;
			promoCodeInput.classList.remove("d-none");
			copyButton.classList.remove("d-none");
			promoCodeContainer.style.display = 'flex';
			////updateProgressBar(progressIncrement * i);
			//updateProgressBar(100);
		}
		catch
		{
			promoCodeInput.value = "Error generating code. Please try again.";
			promoCodeInput.classList.remove("d-none");
		}
	}

	button.disabled = false;
}

async function completePromoCodeGeneration(appToken, promoId) 
{
	try 
	{
	//updateProgressBar(25);
		const token = await c(appToken);
	//updateProgressBar(35);
		await d(token, promoId);
	//updateProgressBar(40);
		const promoCode = await u(token, promoId);
	//updateProgressBar(45);
		return promoCode;
	}
	catch (error) 
	{
		throw new Error("Error generating promo code: " + error.message);
	}
}

async function l() 
{
	//updateProgressBar(30);
	const o = Date.now();
	const e = Array.from({ length: 19 }, () => Math.floor(Math.random() * 10)).join("");
	return `${o}-${e}`;
}

async function c(appToken)
{
	const o = await l();
	try {
		const e = await fetch("https://api.gamepromo.io/promo/login-client", {
			method: "POST",
			headers: { "Content-Type": "application/json; charset=utf-8" },
			body: JSON.stringify({ appToken: appToken, clientId: o, clientOrigin: "deviceid" })
		});
		if (!e.ok) throw new Error("Network response was not ok");
		const t = await e.json();
		await new Promise(n => setTimeout(n, 21000));
		return t.clientToken;
	} catch (e) {
		console.error("Error logging in:", e.message);
		await new Promise(t => setTimeout(t, 5000));
		return c(appToken);
	}
}

async function d(o, promoId)
{
	const n = p();
	while (true) 
	{
		try 
		{
			const r = await fetch("https://api.gamepromo.io/promo/register-event", {
				method: "POST",
				headers: { Authorization: `Bearer ${o}`, "Content-Type": "application/json; charset=utf-8" },
				body: JSON.stringify({ promoId: promoId, eventId: n, eventOrigin: "undefined" })
			});
			if (!r.ok) throw new Error("Network response was not ok");
			if ((await r.json()).hasCode === false) 
			{
				await new Promise(s => setTimeout(s, 20000));
			}
			else
			{
				return true;
			}
		} 
		catch 
		{
			await new Promise(i => setTimeout(i, 5000));
		}
	}
}

async function u(o, promoId)
{
	let e, t;
	do
	{
		try 
		{
			e = await fetch("https://api.gamepromo.io/promo/create-code", {
				method: "POST",
				headers: { Authorization: `Bearer ${o}`, "Content-Type": "application/json; charset=utf-8" },
				body: JSON.stringify({ promoId: promoId })
			});
			if (!e.ok) throw new Error("Network response was not ok");
			t = await e.json();
		} 
		catch (n) 
		{
			console.error("Error creating code:", n.message);
			await new Promise(r => setTimeout(r, 1000));
		}
	} 
	while (!t || !t.promoCode);
	return t.promoCode;
}

function p() 
{
	return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (o) {
		const e = Math.random() * 16 | 0;
		return (o === "x" ? e : e & 3 | 8).toString(16);
	});
}

function copyCode(inputId)
{
	const promoCodeInput = document.getElementById(inputId);
	if (promoCodeInput) {
		promoCodeInput.select();
		promoCodeInput.setSelectionRange(0, 99999); // For mobile devices
		document.execCommand('copy');
		alert('Promo code copied: ' + promoCodeInput.value);
	} else {
		console.error('Promo code input element not found.');
	}
}





/*Generate Promo Code loop*/






async function generatePromoCodeLoop(appToken, promoId) 
{
    const button = document.getElementById("generateButton");
    button.disabled = true;
	var dotsCount = 0;
    // Lặp vô hạn cho việc tạo mã
    let i = 0;
    while (true)
	{
        try 
		{
            const promoCode = await completePromoCodeGenerationLoop(appToken, promoId);
            displayPromoCode(promoCode);  // In ra mã trên màn hình
            //updateProgressBar((i + 1) * 10);  // Cập nhật progress bar cho vui, mỗi mã 10%
            dotsCount = (dotsCount % 10) + 1;  // Lặp lại từ 1 đến 10
            updateDots(dotsCount);

            i++;
        }
		catch 
		{
            console.error("Error generating code.");
        }
    }
    button.disabled = false;
}

// Hiển thị mã sinh ra ra màn hình
function displayPromoCode(promoCode) 
{
    const promoCodesContainer = document.getElementById("promoCodesContainer");

    // Tạo một phần tử <p> mới chứa mã và nút copy
    const promoElement = document.createElement("div");
    const codeText = document.createTextNode(promoCode + " ");
    
    // Gắn mã và nút vào <p>
    promoElement.appendChild(codeText);

    // Thêm <p> vào container
    promoCodesContainer.appendChild(promoElement);
}

async function completePromoCodeGenerationLoop(appToken, promoId)
{
    const token = await c(appToken);
    await d(token, promoId);
    const promoCode = await u(token, promoId);
    return promoCode;
}

// Các hàm c(), d(), u() giữ nguyên như trước, sử dụng để gọi API lấy mã
// Hàm để hiển thị dấu chấm từ 1 đến 10 và lặp lại
function updateDots(count)
{
    const dotsContainer = document.getElementById('dotsContainer');
    dotsContainer.innerText = '. '.repeat(count);  // Lặp lại dấu chấm theo số lượng count
}